package gov.va.med.mhv.sso;

import com.liferay.portal.UserLockoutException;

public class SystemDownException extends UserLockoutException{
             
     private static final long serialVersionUID = 6750776834057569336L;
     
     public enum ErrorCodeEnum {
                     DEFAULT_ERROR(1000, "An error occured while making any API request."),
                     USER_MANAGMENT_FAILURE_USER_PROFILE(1001, "An error occurred requesting User Profile data from the User Management web service."),
                     USER_MANAGMENT_FAILURE_PATIENT(1002, "An error occurred requesting Patient data from the User Management web service."),
                     USER_MANAGMENT_FAILURE_POST_LOGIN_UPDATE(1003, "An error occurred performing post login updates against the User Management web service."),
                     ACCOUNT_VALIDATOR_FAILURE_IS_USER_INACTIVE(1004, "An error occurred checking if the user is inactive against the Account Management web service.");
                     
                     private Integer errorCode;
                     private String message;
                     
                     ErrorCodeEnum(Integer errorCode, String message) {
                                     this.errorCode = errorCode;
                                     this.message = message;
                     }
                     
                     public String getMessage() {
                                     return message;
                     }
                     
                     public Integer getErrorCode() {
                                     return errorCode;
                     }
     };
     
     private ErrorCodeEnum errorCode = ErrorCodeEnum.DEFAULT_ERROR;

     public SystemDownException() {
                     super();
     }
     
     public SystemDownException(ErrorCodeEnum errorCode) {
                     super();
                     this.errorCode = errorCode;
     }

     public SystemDownException(String msg) {
                     super(msg);
     }
     
     public SystemDownException(String msg, Throwable cause) {
                     super(msg, cause);
     }

     public SystemDownException(Throwable cause) {
                     super(cause);
     }
     
     public SystemDownException(ErrorCodeEnum errorCode, Throwable cause) {
                     super(cause);
                     this.errorCode = errorCode;
     }

     public Integer getErrorCode() {
                     if(this.errorCode != null) {
                                     return this.errorCode.getErrorCode();
                     }
                     
                     return -1;
     }
     
     @Override
     public String toString() {
                     return String.format("MHVAPI ERROR CODE: %d, MESSAGE: %s", this.errorCode.getErrorCode(), this.errorCode.getMessage());
     }
}
